/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.DataSetURI;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.SAXException;

public class TestRunScripts {
    private static int testid;
    private static String autoplotJar;
    private static String jre;

    public static void main(String[] args) throws IOException {
        int exitCode = 0;
        autoplotJar = args[0];
        testid = Integer.parseInt(args[1]);
        for (String s : args = Arrays.copyOfRange(args, 2, args.length)) {
            try {
                TestRunScripts.runScriptsInFile(s);
            }
            catch (Exception ex) {
                exitCode = 17;
            }
        }
        System.err.println("exiting with exitCode " + exitCode);
        System.exit(exitCode);
    }

    public static void runScriptsInFile(String uri) {
        LinkedHashMap<String, Exception> exceptions = new LinkedHashMap<String, Exception>();
        LinkedHashMap<String, Integer> exceptionNumbers = new LinkedHashMap<String, Integer>();
        System.err.println("version TestRunScripts 2024-05-13 17:51");
        try {
            int iid;
            System.err.println("\n=======================");
            System.err.println("== from " + uri);
            System.err.println("=======================\n");
            if (uri.endsWith(".xml")) {
                File ff = DataSetURI.getFile((String)uri, (ProgressMonitor)new NullProgressMonitor());
                iid = TestRunScripts.doBookmarks(ff, 0, exceptions, exceptionNumbers);
            } else {
                iid = TestRunScripts.doHtml(new URL(uri), 0, exceptions, exceptionNumbers);
            }
        }
        catch (Exception iid) {
            // empty catch block
        }
        if (exceptions.size() > 0) {
            String s = null;
            for (String k : exceptions.keySet()) {
                if (s == null) {
                    s = k;
                }
                System.err.println("" + k + "\t" + ((Exception)exceptions.get(k)).toString());
            }
            throw new RuntimeException((Throwable)exceptions.get(s));
        }
    }

    private static String do1(String uri, int iid, boolean doTest, boolean isPublic) throws Exception {
        return TestRunScripts.do1(uri, "", iid, doTest, isPublic);
    }

    private static String do1(String uri, String shortId, int iid, boolean doTest, boolean isPublic) throws Exception {
        System.err.printf("== %03d %03d %s ==\n", testid, iid, shortId);
        if (isPublic) {
            System.err.printf("uri: %s\n", uri);
        } else {
            System.err.printf("uri: (uri is not public)\n", new Object[0]);
        }
        String label = shortId.length() > 0 ? String.format("test%03d_%s", testid, shortId) : String.format("test%03d_%03d", testid, iid);
        long t0 = System.currentTimeMillis();
        double tsec = t0;
        double psec = t0;
        CharSequence[] command = new String[]{jre, "-jar", autoplotJar, "--headless", "--scriptExit", "--script=" + uri};
        System.err.println(String.join((CharSequence)" ", command));
        ProcessBuilder pb = new ProcessBuilder((String[])command);
        pb.redirectError(new File(label + ".err.txt"));
        Process p = pb.start();
        p.waitFor();
        if (p.exitValue() != 0) {
            throw new Exception("script got exception: " + uri);
        }
        return shortId;
    }

    private static int doBookmarks(File f, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, SAXException, BookmarksException {
        List<Bookmark> books = Bookmark.parseBookmarks(f.toURI().toURL());
        return TestRunScripts.doBookmarks(books, iid, exceptions, exceptionNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doBookmarks(List<Bookmark> books, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, SAXException, BookmarksException {
        for (Bookmark b : books) {
            boolean hidden = b.isHidden();
            if (!hidden) {
                if (b instanceof Bookmark.Folder) {
                    if (((Bookmark.Folder)b).getRemoteUrl() != null) {
                        System.err.println("Skipping remote bookmarks file " + ((Bookmark.Folder)b).getRemoteUrl());
                        continue;
                    }
                    iid = TestRunScripts.doBookmarks(((Bookmark.Folder)b).getBookmarks(), iid, exceptions, exceptionNumbers);
                    continue;
                }
                String uri = ((Bookmark.Item)b).getUri();
                try {
                    TestRunScripts.do1(uri, iid, true, true);
                    continue;
                }
                catch (Exception ex) {
                    exceptions.put(uri, ex);
                    continue;
                }
                finally {
                    ++iid;
                    continue;
                }
            }
            if (b instanceof Bookmark.Folder) {
                System.err.println("Skipping hidden bookmark: \n\t" + b.getTitle() + "\n\t" + b.getDescription());
                continue;
            }
            if (!(b instanceof Bookmark.Item)) continue;
            System.err.println("Skipping hidden bookmark: \n\t" + ((Bookmark.Item)b).getUri() + "\n\t" + b.getTitle() + "\n\t" + b.getDescription());
            ++iid;
        }
        return iid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doHtml(URL url, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, CancelledOperationException {
        File f = DataSetURI.getFile((String)url.toString());
        try (FileInputStream in = new FileInputStream(f);){
            URL[] urls = HtmlUtil.getDirectoryListing((URL)url, (InputStream)in, (boolean)false);
            ArrayList result = new ArrayList();
            ArrayList<String> sresult = new ArrayList<String>();
            for (URL url1 : urls) {
                if (!url1.getFile().endsWith(".jy")) continue;
                sresult.add(url1.toString());
            }
            for (String suri : sresult) {
                try {
                    TestRunScripts.do1(suri, iid, true, true);
                }
                catch (Exception ex) {
                    exceptions.put(suri, ex);
                    exceptionNumbers.put(suri, iid);
                }
                finally {
                    ++iid;
                }
            }
            int n = iid;
            return n;
        }
    }

    static {
        jre = System.getenv("JAVA_HOME") + "/bin/java";
    }
}

